<?php
    in_file();

    class Mdonate extends model
    {
        public $error = false, $vars = [];
        public $hash_item = '';
        protected $paypal_ipn_url = 'https://www.paypal.com/cgi-bin/webscr';
		protected $paypal_ipn_url_ssl = 'www.paypal.com';												 
        protected $req = 'cmd=_notify-validate';
        protected $post = [];
        protected $paypal_response;
        protected $paypal_debug = 0;
        public $order_details = [];
        protected $pw_reason_list = [0 => 'Invalid Reason', 1 => 'Chargeback', 2 => 'Credit Card fraud', 3 => 'Order fraud', 4 => 'Bad data entry', 5 => 'Fake / proxy user', 6 => 'Rejected by advertiser', 7 => 'Duplicate conversions', 8 => 'Goodwill credit taken back', 9 => 'Cancelled order', 10 => 'Partially reversed transaction'];
        public $google_package = [];

        public function __set($key, $val)
        {
            $this->vars[$key] = $val;
        }

        public function __isset($name)
        {
            return isset($this->vars[$name]);
        }

        public function set_ipn_listeners($data)
        {
            $server = explode('-', $data, 2)[1];
            if($this->config->values('donation_config', [$server, 'paypal', 'sandbox']) == 1){
                $this->paypal_ipn_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
                $this->paypal_ipn_url_ssl = 'www.sandbox.paypal.com';
            }
        }

        public function get_paypal_packages()
        {
            return $this->website->db('web')->query('SELECT id, package, reward, price, currency FROM DmN_Donate_Packages WHERE status = 1 AND server = \'' . $this->website->db('web')->sanitize_var($this->session->userdata(['user' => 'server'])) . '\' ORDER BY orders ASC')->fetch_all();
        }

        public function get_interkassa_packages()
        {
            return $this->website->db('web')->query('SELECT id, package, reward, price, currency FROM DmN_Donate_Interkassa_Packages WHERE status = 1 AND server = \'' . $this->website->db('web')->sanitize_var($this->session->userdata(['user' => 'server'])) . '\' ORDER BY orders ASC')->fetch_all();
        }

        public function get_paycall_packages()
        {
            return $this->website->db('web')->query('SELECT id, package, reward, price FROM DmN_Donate_PayCall_Packages WHERE status = 1 AND server = \'' . $this->website->db('web')->sanitize_var($this->session->userdata(['user' => 'server'])) . '\' ORDER BY orders ASC')->fetch_all();
        }

        public function get_cuenta_digital_packages()
        {
            return $this->website->db('web')->query('SELECT id, package, reward, price, currency FROM DmN_Donate_CuentaDigital_Packages WHERE status = 1 AND server = \'' . $this->website->db('web')->sanitize_var($this->session->userdata(['user' => 'server'])) . '\' ORDER BY orders ASC')->fetch_all();
        }

        public function check_package($id)
        {
            $count = $this->website->db('web')->snumrows('SELECT COUNT(id) as count FROM DmN_Donate_Packages WHERE id = ' . $this->website->db('web')->sanitize_var($id) . ' AND status = 1');
            return ($count == 1);
        }

        public function get_paypal_package_data_by_id($id)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 reward, price, currency FROM DmN_Donate_Packages WHERE id = :id AND status = 1 AND server = :server');
            $stmt->execute([':id' => $id, ':server' => $this->session->userdata(['user' => 'server'])]);
            return $stmt->fetch();
        }

        public function get_paycall_package_data_by_id($id)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 reward, price FROM DmN_Donate_PayCall_Packages WHERE id = :id AND status = 1 AND server = :server');
            $stmt->execute([':id' => $id, ':server' => $this->session->userdata(['user' => 'server'])]);
            return $stmt->fetch();
        }

        public function get_cuenta_digital_package_data_by_id($id)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 reward, price, currency FROM DmN_Donate_CuentaDigital_Packages WHERE id = :id AND status = 1 AND server = :server');
            $stmt->execute([':id' => $id, ':server' => $this->session->userdata(['user' => 'server'])]);
            return $stmt->fetch();
        }

        public function get_interkassa_package_data_by_id($id)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 reward, price, currency FROM DmN_Donate_Interkassa_Packages WHERE id = :id AND status = 1 AND server = :server');
            $stmt->execute([':id' => $id, ':server' => $this->session->userdata(['user' => 'server'])]);
            return $stmt->fetch();
        }

        public function insert_paypal_order($reward, $price, $currency)
        {
            $this->hash_item = md5($this->session->userdata(['user' => 'username']) . $price . $currency . uniqid(microtime(), 1));
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Orders (amount, currency, credits, account, server, hash) VALUES(:amount, :currency, :credits, :account, :server, :hash)');
            return $stmt->execute([':amount' => $price, ':currency' => $currency, ':credits' => $reward, ':account' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server']), ':hash' => $this->hash_item]);
        }

        public function insert_interkassa_order($reward, $price, $currency)
        {
            $this->hash_item = md5($this->session->userdata(['user' => 'username']) . $price . $currency . uniqid(microtime(), 1));
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Interkassa_Orders (amount, currency, credits, account, server, hash) VALUES(:amount, :currency, :credits, :account, :server, :hash)');
            return $stmt->execute([':amount' => $price, ':currency' => $currency, ':credits' => $reward, ':account' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server']), ':hash' => $this->hash_item]);
        }

        public function insert_paycall_order($reward, $price)
        {
            $this->hash_item = md5($this->session->userdata(['user' => 'username']) . $price . uniqid(microtime(), 1));
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Paycall_Orders (amount, credits, account, server, hash) VALUES(:amount, :credits, :account, :server, :hash)');
            return $stmt->execute([':amount' => $price, ':credits' => $reward, ':account' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server']), ':hash' => $this->hash_item]);
        }

        public function get_paypal_data()
        {
            return ['email' => $this->config->values('donation_config', [$this->session->userdata(['user' => 'server']), 'paypal', 'email']), 'item' => $this->hash_item, 'user' => $this->session->userdata(['user' => 'username']), 'server' => $this->session->userdata(['user' => 'server'])];
        }

        public function get_paycall_data($reward, $price)
        {
            return ['business_code' => $this->config->values('donation_config', [$this->session->userdata(['user' => 'server']), 'paycall', 'business_code']), 'item' => $this->hash_item, 'user' => $this->session->userdata(['user' => 'username']), 'server' => $this->session->userdata(['user' => 'server']), 'reward' => $reward, 'price' => $price, 'business_name' => $this->config->config_entry('main|servername')];
        }

        public function check_paycall_order($item)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 amount, credits, account, server FROM DmN_Donate_PayCall_Orders WHERE hash = :item');
            $stmt->execute([':item' => $item]);
            $this->order_details = $stmt->fetch();
        }

        public function verifiedTransaction($paycall_unique, $business_code, $test_mode = 0)
        {
            $requestArg = ["service" => "chckTrans", "tId" => $paycall_unique, "cId" => $business_code, "test" => ($test_mode == 1) ? 1 : 0];
            $res = $this->get_paycall_url('http://admin.paycall.co.il/ws.php', 0, http_build_query($requestArg));
            $info = simplexml_load_string($res);
            if((string)$info->RESULT == "true" && (string)$info->LOOKUP == "0")
                return true;
            return false;
        }

        private function get_paycall_url($url, $wsMethod = 1, $argQuery = "")
        {
            if($wsMethod == 1){
                if(strpos($url, "?") !== false)
                    $url = $url . "&" . $argQuery; else
                    $url = $url . "?" . $argQuery;
            }
            if(function_exists('curl_init') == true){
                $ch = curl_init();// || $this->writelog(curl_error(), 'Paycall');
                curl_setopt($ch, CURLOPT_URL, $url);
                if($wsMethod == 0){
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $argQuery);
                }
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $data = curl_exec($ch);
                curl_close($ch);
            } else{
                if($wsMethod == 1){
                    $file = fopen($url, "r");
                    if(!$file){
                        $this->writelog('Unable to open remote file.', 'Paycall');
                        exit;
                    }
                    while(!feof($file))
                        $data .= fgets($file, 64);
                    fclose($file);
                } else{
                    $opts = ['http' => ['method' => 'POST', 'header' => 'Content-type: application/x-www-form-urlencoded', 'content' => $argQuery]];
                    $context = stream_context_create($opts);
                    $file = fopen($url, "r", false, $context);
                    if(!$file){
                        $this->writelog('Unable to open remote file.', 'Paycall');
                        exit;
                    }
                    $data = '';
                    while(!feof($file))
                        $data .= fgets($file, 64);
                    fclose($file);
                }
            }
            return $data;
        }

        public function get_2checkout_packages()
        {
            return $this->website->db('web')->query('SELECT id, package, reward, price, currency FROM DmN_2CheckOut_Packages WHERE status = 1 AND server = \'' . $this->website->db('web')->sanitize_var($this->session->userdata(['user' => 'server'])) . '\' ORDER BY orders ASC')->fetch_all();
        }

        public function get_pagseguro_packages()
        {
            return $this->website->db('web')->query('SELECT id, package, reward, price, currency FROM DmN_PagSeguro_Packages WHERE status = 1 AND server = \'' . $this->website->db('web')->sanitize_var($this->session->userdata(['user' => 'server'])) . '\' ORDER BY orders ASC')->fetch_all();
        }

        public function check_2checkout_package($id = -1)
        {
            $stmt = $this->website->db('web')->prepare('SELECT package, reward, price, currency FROM DmN_2CheckOut_Packages WHERE status = 1 AND id = :id');
            $stmt->execute([':id' => $this->website->c($id)]);
            return $stmt->fetch();
        }

        public function check_pagseguro_package($id = -1)
        {
            $stmt = $this->website->db('web')->prepare('SELECT package, reward, price, currency FROM DmN_PagSeguro_Packages WHERE status = 1 AND id = :id');
            $stmt->execute([':id' => $this->website->c($id)]);
            return $stmt->fetch();
        }

        public function insert_2checkout_order($reward, $price, $currency, $item)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_2CheckOut_Orders (amount, currency, credits, account, server, hash) VALUES(:amount, :currency, :credits, :account, :server, :hash)');
            return $stmt->execute([':amount' => $price, ':currency' => $currency, ':credits' => $reward, ':account' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server']), ':hash' => $item]);
        }

        public function insert_pagseguro_order($reward, $price, $currency, $item)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_PagSeguro_Orders (amount, currency, credits, account, server, hash) VALUES(:amount, :currency, :credits, :account, :server, :hash)');
            return $stmt->execute([':amount' => $price, ':currency' => $currency, ':credits' => $reward, ':account' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server']), ':hash' => $item]);
        }

        public function insert_cuenta_digital_order($reward, $price, $currency, $item)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_CuentaDigital_Orders (amount, currency, credits, account, server, hash) VALUES(:amount, :currency, :credits, :account, :server, :hash)');
            return $stmt->execute([':amount' => $price, ':currency' => $currency, ':credits' => $reward, ':account' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server']), ':hash' => $item]);
        }

        public function get_2checkout_order_data($hash)
        {
            $stmt = $this->website->db('web')->prepare('SELECT amount, currency, credits, account, server FROM DmN_2CheckOut_Orders WHERE hash = :hash');
            $stmt->execute([':hash' => $this->website->c($hash)]);
            return $stmt->fetch();
        }

        public function get_pagseguro_order_data($hash)
        {
            $stmt = $this->website->db('web')->prepare('SELECT amount, currency, credits, account, server FROM DmN_PagSeguro_Orders WHERE hash = :hash');
            $stmt->execute([':hash' => $this->website->c($hash)]);
            return $stmt->fetch();
        }

        public function get_cuenta_digital_order_data($hash)
        {
            $stmt = $this->website->db('web')->prepare('SELECT amount, currency, credits, account, server FROM DmN_Donate_CuentaDigital_Orders WHERE hash = :hash');
            $stmt->execute([':hash' => $this->website->c($hash)]);
            return $stmt->fetch();
        }

        public function check_existing_2checkout_transaction($order_number)
        {
            $stmt = $this->website->db('web')->prepare('SELECT id FROM DmN_2CheckOut_Transactions WHERE transaction_id = :order');
            $stmt->execute([':order' => $this->website->c($order_number)]);
            return $stmt->fetch();
        }

        public function check_existing_cuenta_digital_transaction($hash)
        {
            $stmt = $this->website->db('web')->prepare('SELECT id FROM DmN_Donate_CuentaDigital_Transactions WHERE order_hash = :hash');
            $stmt->execute([':hash' => $this->website->c($hash)]);
            return $stmt->fetch();
        }

        public function check_existing_pagseguro_transaction($order_number)
        {
            $stmt = $this->website->db('web')->prepare('SELECT id FROM DmN_PagSeguro_Transactions WHERE transaction_id = :order');
            $stmt->execute([':order' => $this->website->c($order_number)]);
            return $stmt->fetch();
        }

        public function insert_2checkout_transaction($order_number, $amount, $currency, $account, $server, $credits, $email, $hash)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_2CheckOut_Transactions (transaction_id, amount, currency, acc, server, credits, order_date, payer_email, order_hash) VALUES (:trans_id, :gross, :currency, :account, :server, :credits, :time, :payer_email, :order_hash)');
            return $stmt->execute([':trans_id' => $order_number, ':gross' => $amount, ':currency' => $currency, ':account' => $account, ':server' => $server, ':credits' => $credits, ':time' => time(), ':payer_email' => $email, ':order_hash' => $hash]);
        }

        public function insert_cuenta_digital_transaction($amount, $currency, $account, $server, $credits, $hash)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_CuentaDigital_Transactions (amount, currency, acc, server, credits, order_date, order_hash) VALUES (:gross, :currency, :account, :server, :credits, :time, :order_hash)');
            return $stmt->execute([':gross' => $amount, ':currency' => $currency, ':account' => $account, ':server' => $server, ':credits' => $credits, ':time' => time(), ':order_hash' => $hash]);
        }

        public function insert_pagseguro_transaction($order_number, $amount, $currency, $account, $server, $credits, $hash)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_PagSeguro_Transactions (transaction_id, amount, currency, acc, server, credits, order_date, order_hash) VALUES (:trans_id, :gross, :currency, :account, :server, :credits, :time, :order_hash)');
            return $stmt->execute([':trans_id' => $order_number, ':gross' => $amount, ':currency' => $currency, ':account' => $account, ':server' => $server, ':credits' => $credits, ':time' => time(), ':order_hash' => $hash]);
        }

        public function gen_post_fields($data)
        {
            $data_array = explode('&', $data);
            foreach($data_array as $value){
                $value = explode('=', $value);
                if(count($value) == 2)
                    $this->post[$value[0]] = urldecode($value[1]);
            }
            foreach($this->post as $key => $value){
                $this->req .= "&" . $key . "=" . urlencode($value);
            }
            //$this->req = str_replace('amp;', '', html_entity_decode($this->req, ENT_COMPAT, 'UTF-8'));
            $this->writelog('Paypal request ' . $this->req . '', 'Paypal');
        }

        public function post_back_paypal()
        {
            $request = curl_init($this->paypal_ipn_url);
            if($request == false){
                $this->writelog('Unable to initialize curl.', 'Paypal');
                return false;
            }
            curl_setopt($request, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            curl_setopt($request, CURLOPT_POST, 1);
            curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($request, CURLOPT_POSTFIELDS, $this->req);
            curl_setopt($request, CURLOPT_SSL_VERIFYPEER, 1);
            curl_setopt($request, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($request, CURLOPT_FORBID_REUSE, 1);
            curl_setopt($request, CURLOPT_USERAGENT, 'DmN MuCMS');
            if($this->paypal_debug == 1){
                curl_setopt($request, CURLOPT_HEADER, 1);
                curl_setopt($request, CURLINFO_HEADER_OUT, 1);
            }
            curl_setopt($request, CURLOPT_CONNECTTIMEOUT, 30);
            curl_setopt($request, CURLOPT_HTTPHEADER, ['Connection: Close']);
            curl_setopt($request, CURLOPT_CAINFO, APP_PATH . DS . 'data' . DS . 'cacert.pem');
            $this->paypal_response = curl_exec($request);
            if(curl_errno($request) != 0){
                $this->writelog('Can\'t connect to PayPal to validate IPN message:' . curl_error($request), 'Paypal');
                return false;
            } else{
                if($this->paypal_debug == 1){
                    $this->writelog('HTTP request of validation request:' . curl_getinfo($request, CURLINFO_HEADER_OUT) . ' for IPN payload: ' . $this->req, 'Paypal');
                    $this->writelog('HTTP response of validation request: ' . $this->paypal_response, 'Paypal');
                }
                $tokens = explode("\r\n\r\n", trim($this->paypal_response));
                $this->paypal_response = trim(end($tokens));
                curl_close($request);
                return true;
            }
        }

        public function validate_paypal_payment()
        {
            if(stripos($this->paypal_response, "VERIFIED") !== false){
                if(!$this->check_order_number()){
                    return false;
                }
                if(!$this->check_email()){
                    return false;
                }
                $price = $this->order_details['amount'];
                $transaction_fee = $this->config->values('donation_config', [$this->order_details['server'], 'paypal', 'paypal_fee']);
                $fixed_fee = $this->config->values('donation_config', [$this->order_details['server'], 'paypal', 'paypal_fixed_fee']);
                if(isset($transaction_fee) && $transaction_fee != ''){
                    $fee = ($transaction_fee / 100) * $price;
                    $price = $price + $fee;
                }
                if(isset($fixed_fee) && $fixed_fee != ''){
                    $price += $fixed_fee;
                }
                switch($this->vars['payment_status']){
                    case 'Completed':
                        if($this->vars['tax'] > 0){
                            $this->vars['mc_gross'] -= $this->vars['tax'];
                        }
                        if($this->vars['mc_gross'] == number_format($price, 2, '.', ',')){
                            if($this->vars['mc_currency'] == $this->order_details['currency']){
                                if($this->check_completed_transaction()){
                                    return false;
                                }
                                if($this->check_pending_transaction()){
                                    if($this->update_transaction_status()){
                                        return true;
                                    }
                                } else{
                                    if($this->insert_transaction_status()){
                                        return true;
                                    }
                                }
                            } else{
                                $this->writelog('Package currency does not match [transaction id: ' . $this->vars['txn_id'] . '], [currency received: ' . $this->vars['mc_currency'] . '], [package currency: ' . $this->order_details['currency'] . ']', 'Paypal');
                            }
                        } else{
                            $this->writelog('Package price does not match [transaction id: ' . $this->vars['txn_id'] . '], [price received: ' . $this->vars['mc_gross'] . '], [package price: ' . number_format($price, 2, '.', ',') . ']', 'Paypal');
                        }
                        break;
                    case 'Pending':
                        if($this->vars['tax'] > 0){
                            $this->vars['mc_gross'] -= $this->vars['tax'];
                        }
                        if($this->vars['mc_gross'] == number_format($price, 2, '.', ',')){
                            if(!$this->check_completed_transaction() && !$this->check_pending_transaction()){
                                $this->insert_transaction_status();
                            }
                        } else{
                            $this->writelog('Package price does not match [transaction id: ' . $this->vars['txn_id'] . '], [price received: ' . $this->vars['mc_gross'] . '], [package price: ' . number_format($price, 2, '.', ',') . ']', 'Paypal');
                        }
                        break;
                    case 'Reversed':
                    case 'Refunded':
                        if(!$this->check_refunded_transaction()){
                            $this->decrease_credits($this->order_details['account'], $this->order_details['server'], $this->order_details['credits'], $this->config->values('donation_config', [$this->order_details['server'], 'paypal', 'reward_type']));
                            $this->update_transaction_status(true);
                            if($this->config->values('donation_config', [$this->order_details['server'], 'paypal', 'punish_player']) == 1){
                                $this->block_user($this->order_details['account'], $this->order_details['server']);
                            }
                        }
                        break;
                }
            } else if(stripos($this->paypal_response, "INVALID") !== false){
                $this->writelog('PayPal sent [status: INVALID] [transaction id: ' . $this->vars['txn_id'] . '] [response:' . print_r($this->paypal_response, true) . ']', 'Paypal');
            } else{
                $this->writelog('PayPal sent [status: UNKNOWN] [transaction id: ' . $this->vars['txn_id'] . '] [response:' . print_r($this->paypal_response, true) . ']', 'Paypal');
            }
            return false;
        }

        public function validate_paycall_payment($paycall_unique, $hash, $total_amount)
        {
            if($this->check_paycall_transaction($hash)){
                $this->writelog('Transaction already proccesse.', 'Paycall');
                return false;
            } else{
                if($this->insert_paycall_transaction($paycall_unique, $hash, $total_amount)){
                    return true;
                }
            }
        }

        private function check_paycall_transaction($hash)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 id FROM DmN_Donate_PayCall_Transactions WHERE order_hash = :item');
            $stmt->execute([':item' => $hash]);
            return $stmt->fetch();
        }

        private function insert_paycall_transaction($paycall_unique, $hash, $total_amount)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_PayCall_Transactions (transaction_id, amount, acc, server, credits, order_date, order_hash) VALUES (:transid, :amount, :acc, :server, :credits, :order_date, :order_hash)');
            return $stmt->execute([':transid' => $paycall_unique, ':amount' => $total_amount, ':acc' => $this->order_details['account'], ':server' => $this->order_details['server'], ':credits' => $this->order_details['credits'], ':order_date' => time(), ':order_hash' => $hash]);
        }

        public function check_email($email = '')
        {
            $email = ($email != '') ? $email : $this->vars['receiver_email'];
            $email2 = ($email != '') ? $email : $this->vars['business'];
            if(strtolower($email) != strtolower($this->config->values('donation_config', [$this->order_details['server'], 'paypal', 'email'])) && strtolower($email2) != strtolower($this->config->values('donation_config', [$this->order_details['server'], 'paypal', 'email']))){
                $this->writelog('PayPal sent invalid reciever email: ' . $email . ', business email: ' . $email2, 'Paypal');
                return false;
            }
            return true;
        }


        public function check_interkassa_order_number($trans_id)
        {
            $this->order_details = $this->website->db('web')->query('SELECT amount, currency, account, server, credits FROM DmN_Donate_Interkassa_Orders where hash = \'' . $this->website->db('web')->sanitize_var($trans_id) . '\'')->fetch();
            if(is_array($this->order_details))
                return true;
            return false;
        }

        public function check_completed_interkassa_transaction($trans_id)
        {
            $count = $this->website->db('web')->snumrows('SELECT COUNT(id) AS count FROM DmN_Donate_Interkassa_Transactions where transaction_id = \'' . $this->website->db('web')->sanitize_var($trans_id) . '\'');
            if($count > 0){
                return true;
            }
            return false;
        }

        public function insert_interkassa_transaction($trans_id, $amount)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Interkassa_Transactions (transaction_id, amount, currency, acc, server, credits, order_date) VALUES (:trans_id, :gross, :currency, :account, :server, :credits, :time)');
            return $stmt->execute([':trans_id' => $trans_id, ':gross' => $amount, ':currency' => $this->order_details['currency'], ':account' => $this->order_details['account'], ':server' => $this->order_details['server'], ':credits' => $this->order_details['credits'], ':time' => time()]);
        }

        public function check_order_number($item = '')
        {
            $item = ($item != '') ? $item : $this->vars['item_number'];
            $count = $this->website->db('web')->snumrows('SELECT COUNT(id) AS count FROM DmN_Donate_Orders where hash = \'' . $this->website->db('web')->sanitize_var($item) . '\'');
            if($count == 1){
                $this->order_details = $this->website->db('web')->query('SELECT amount, currency, account, server, credits FROM DmN_Donate_Orders where hash = \'' . $this->website->db('web')->sanitize_var($item) . '\'')->fetch();
                return true;			 	 
            } else{   
                $this->writelog('PayPal sent invalid order [transaction id: ' . $this->vars['txn_id'] . ']', 'Paypal');
                return false;
				 
            }
        }

        public function check_completed_transaction($id = '')
        {
            $id = ($id != '') ? $id : $this->vars['txn_id'];
            $count = $this->website->db('web')->snumrows('SELECT COUNT(id) AS count FROM DmN_Donate_Transactions where transaction_id = \'' . $this->website->db('web')->sanitize_var($id) . '\' and status = \'Completed\'');
            if($count > 0){
                return true;
            }
            return false;
        }

        public function check_pending_transaction($id = '')
        {
            $id = ($id != '') ? $id : $this->vars['txn_id'];
            $count = $this->website->db('web')->snumrows('SELECT COUNT(id) AS count FROM DmN_Donate_Transactions where transaction_id = \'' . $this->website->db('web')->sanitize_var($id) . '\' and status = \'Pending\'');
            if($count > 0){
                return true;
            }
            return false;
        }


        private function check_refunded_transaction()
        {
            $count = $this->website->db('web')->snumrows('SELECT COUNT(id) AS count FROM DmN_Donate_Transactions where transaction_id = \'' . $this->website->db('web')->sanitize_var($this->vars['parent_txn_id']) . '\' and (status = \'Refunded\' OR status = \'Reversed\')');
            if($count > 0){
                return true;
            }
            return false;
        }

        private function update_transaction_status($refund = false, $id = '', $status = '')
        {
            $tnx_id = ($refund == false) ? ($id != '') ? $id : $this->vars['txn_id'] : $this->vars['parent_txn_id'];
            $status = ($status != '') ? $status : $this->vars['payment_status'];
            $stmt = $this->website->db('web')->prepare('UPDATE DmN_Donate_Transactions SET status = :status WHERE transaction_id = :trans_id');
            return $stmt->execute([':status' => $status, ':trans_id' => $tnx_id]);
        }

       public function insert_transaction_status($id = '', $gross = '', $currency = '', $status = '', $email = '', $hash = '', $country = '')
        {
            $id = ($id != '') ? $id : $this->vars['txn_id'];
            $gross = ($gross != '') ? $gross : $this->vars['mc_gross'];
            $currency = ($currency != '') ? $currency : $this->vars['mc_currency'];
            $status = ($status != '') ? $status : $this->vars['payment_status'];
            $email = ($email != '') ? $email : $this->vars['payer_email'];
            $hash = ($hash != '') ? $hash : $this->vars['item_number'];
            $country = ($country != '') ? $country : $this->vars['residence_country'];
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Transactions (transaction_id, amount, currency, acc, server, credits, order_date, status, payer_email, order_hash, country) VALUES (:trans_id, :gross, :currency, :account, :server, :credits, :time, :payment_status, :payer_email, :order_hash, :country)');
            return $stmt->execute([':trans_id' => $id, ':gross' => $gross, ':currency' => $currency, ':account' => $this->order_details['account'], ':server' => $this->order_details['server'], ':credits' => $this->order_details['credits'], ':time' => time(), ':payment_status' => $status, ':payer_email' => $email, ':order_hash' => $hash, ':country' => $country]);
        }

        public function get_guid($acc)
        {
            $stmt = $this->account_db->prepare('SELECT memb_guid FROM MEMB_INFO WHERE memb___id = :acc');
            $stmt->execute([':acc' => $acc]);
            $guid = $stmt->fetch();
            if($guid){
                return $guid['memb_guid'];
            }
            return false;
        }

        public function get_email($acc)
        {
            $stmt = $this->account_db->prepare('SELECT mail_addr FROM MEMB_INFO WHERE memb___id = :acc');
            $stmt->execute([':acc' => $acc]);
            if($email = $stmt->fetch()){
                return $email['mail_addr'];
            }
            return false;
        }

        private function check_vip($account, $server)
        {
            $stmt = $this->website->db('web')->prepare('SELECT viptype, viptime FROM DmN_Vip_Users WHERE memb___id = :account AND server = :server');
            $stmt->execute([':account' => $account, ':server' => $server]);
            return $stmt->fetch();
        }

        private function get_vip_package_donation_bonus($id, $server)
        {
            $stmt = $this->website->db('web')->prepare('SELECT TOP 1 bonus_credits_for_donate FROM DmN_Vip_Packages WHERE id = :id AND server = :server  AND status = 1 ORDER BY id ASC');
            $stmt->execute([':id' => $id, ':server' => $server]);
            return $stmt->fetch();
        }

        public function reward_user($account, $server, $credits, $reward_type = 2, $guid = false)
        {
            if($vip_data = $this->check_vip($account, $server)){
                if($vip_data['viptime'] > time()){
                    if($package = $this->get_vip_package_donation_bonus($vip_data['viptype'], $server)){
                        $bonus = ($credits / 100) * $package['bonus_credits_for_donate'];
                        $credits += $bonus;
                        $this->add_account_log('Vip bonus ' . $this->website->translate_credits($reward_type, $server) . ' for donation', $bonus, $account, $server);
                    }
                }
            }
            $this->website->add_credits($account, $server, abs(floor($credits)), $reward_type, false, $guid);
        }

        public function decrease_credits($account, $server, $credits, $decrease_type = 2)
        {
            $this->website->charge_credits($account, $server, abs(floor($credits)), $decrease_type);
        }

        public function block_user($acc, $server)
        {
            $stmt = $this->account_db->prepare('UPDATE MEMB_INFO SET bloc_code = 1 WHERE memb___id = :account');
            $stmt->execute([':account' => $acc]);
            $this->add_to_banlist($acc, $server);
        }

        private function add_to_banlist($acc, $server)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Ban_List (name, type, server, time) VALUES (:name, :type, :server, :time)');
            $stmt->execute([':name' => $acc, ':type' => 1, ':server' => $server, ':time' => strtotime('+5 years')]);
        }

        public function validate_ip_list($data, $type = 'paymentwall')
        {
			$server = explode('-server-', $data)[1];
			return (in_array(ip(), explode(',', $this->config->values('donation_config', [$server, $type, 'allowed_ip_list']))));
        }


        public function validate_superrewards_signature()
        {
            return (md5($this->vars['id'] . ':' . $this->vars['new'] . ':' . $this->vars['uid'] . '-server-' . $this->vars['server'] . ':' . $this->config->values('donation_config', [$this->vars['server'], 'superrewards', 'postback_key'])) == $this->vars['sig']);
        }

        public function validate_superrewards_payment()
        {
            if(!$this->check_transid()){
                if($this->log_superrewards_transaction()){
                    return true;
                }
            }
        }

        public function check_reference($uid, $server, $ref)
        {
            $count = $this->website->db('web')->snumrows('SELECT COUNT(uid) AS count FROM DmN_Donate WHERE uid = \'' . $this->website->db('web')->sanitize_var($uid) . '\' AND server = \'' . $this->website->db('web')->sanitize_var($server) . '\' AND ref = \'' . $this->website->db('web')->sanitize_var($ref) . '\'');
            if($count > 0){
                return true;
            }
            return false;
        }

        private function check_transid()
        {
            $count = $this->website->db('web')->snumrows('SELECT COUNT(uid) AS count FROM DmN_Donate_SuperRewards WHERE uid = \'' . $this->website->db('web')->sanitize_var($this->vars['uid']) . '\' AND server = \'' . $this->website->db('web')->sanitize_var($this->vars['server']) . '\' AND trans_id = ' . $this->website->db('web')->sanitize_var($this->vars['id']) . '');
            if($count > 0){
                return true;
            }
            return false;
        }

        private function log_superrewards_transaction()
        {
            $prepare = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_SuperRewards (trans_id, uid, server, new, total, order_date) VALUES (:tid, :uid, :server, :new, :total, :time)');
            return $prepare->execute([':tid' => $this->vars['id'], ':uid' => $this->vars['uid'], ':server' => $this->vars['server'], ':new' => $this->vars['new'], ':total' => $this->vars['total'], ':time' => time()]);
        }

        public function log_pw_transaction($uid, $server, $currency, $type, $ref)
        {
            $prepare = $this->website->db('web')->prepare('INSERT INTO DmN_Donate (uid, server, currency, type, ref, reason, order_date) VALUES (:uid, :server, :currency, :type, :ref, :reason, :time)');
            return $prepare->execute([':uid' => $uid, ':server' => $server, ':currency' => $currency, ':type' => $type, ':ref' => $ref, ':reason' => 'Complete', ':time' => time()]);
        }

        public function change_pw_transaction_status($currency, $reason, $uid, $ref)
        {
            $stmt = $this->website->db('web')->prepare('UPDATE DmN_Donate SET currency = :currency, reason = :reason, order_date = :order_date WHERE uid =:uid AND ref = :ref');
            $stmt->execute([':currency' => $currency, ':reason' => $this->pw_reason_list[$reason], ':order_date' => time(), ':uid' => $uid, ':ref' => $ref]);
        }

        public function add_account_log($log, $credits, $acc, $server)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Account_Logs (text, amount, date, account, server) VALUES (:text, :amount, GETDATE(), :acc, :server)');
            $stmt->execute([':text' => $log, ':amount' => round($credits), ':acc' => $acc, ':server' => $server]);
            $stmt->close_cursor();
        }

        public function check_fortumo_transaction($id)
        {
            $stmt = $this->website->db('web')->prepare('SELECT payment_id FROM DmN_Donate_Fortumo WHERE payment_id = :payment');
            $stmt->execute([':payment' => $id]);
            return ($stmt->fetch()) ? true : false;
        }

        public function log_fortumo_transaction($id, $sender, $acc, $server, $amount)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Fortumo (payment_id, sender, account, server, credits) VALUES (:payment, :sender, :acc, :server, :amount)');
            $stmt->execute([':payment' => $id, ':sender' => $sender, ':acc' => $acc, ':server' => $server, ':amount' => $amount]);
        }

        public function fortumo_sig_check($params_array)
        {
            $server = explode('-server-', $params_array['cuid'])[1];
            ksort($params_array);
            $str = '';
            foreach($params_array as $k => $v){
                if($k != 'sig' && $k != 'action'){
                    $str .= "$k=$v";
                }
            }
            $str .= $this->config->values('donation_config', [$server, 'fortumo', 'secret']);
            $signature = md5($str);
            return $signature;
        }

        public function log_paygol_transaction($message_id, $message, $shortcode, $sender, $operator, $country, $currency, $price, $acc, $server)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_PayGoal_Log(message_id, message, shortcode, sender, operator, country, currency, price, acc, server) VALUES (:message_id, :message, :shortcode, :sender, :operator, :country, :currency, :price, :acc, :server)');
            $stmt->execute([':message_id' => $message_id, ':message' => $message, ':shortcode' => $shortcode, ':sender' => $sender, ':operator' => $operator, ':country' => $country, ':currency' => $currency, ':price' => $price, ':acc' => $acc, ':server' => $server]);
        }

        public function writelog($logentry, $lgname)
        {
            $log = '[' . ip() . '] ' . $logentry;
            $logfile = @fopen(APP_PATH . DS . 'logs' . DS . $lgname . '_' . date("m-d-y") . '.txt', "a+");
            if($logfile){
                fwrite($logfile, "[" . date("h:iA") . "] $log\r\n");
                fclose($logfile);
            }
        }

        public function get_bank_data($bank, $ref_number)
        {
            $stmt = $this->website->db('web')->prepare('SELECT id, is_assigned, account, server, reward, reward_type  FROM DmN_Donate_Bank_Transfer WHERE bank_code = :code AND refference_number = :ref_number');
            $stmt->execute([':code' => $bank, ':ref_number' => $ref_number]);
            return $stmt->fetch();
        }

        public function insert_refference_number($bank, $ref_number)
        {
            $stmt = $this->website->db('web')->prepare('INSERT INTO DmN_Donate_Bank_Transfer(bank_code, refference_number, account, server) VALUES (:code, :ref_number, :user, :server)');
            return $stmt->execute([':code' => $bank, ':ref_number' => $ref_number, ':user' => $this->session->userdata(['user' => 'username']), ':server' => $this->session->userdata(['user' => 'server'])]);
        }

        public function assign_refference_number($id, $account, $server)
        {
            $stmt = $this->website->db('web')->prepare('UPDATE DmN_Donate_Bank_Transfer SET is_assigned = 1, account = :account, server = :server WHERE id = :id');
            return $stmt->execute([':id' => $id, ':account' => $account, ':server' => $server]);
        }

        public function sent_donate_email($user, $server, $email, $amount, $type, $balance)
        {
            $body = @file_get_contents(APP_PATH . DS . 'data' . DS . 'email_patterns' . DS . 'donate_email_pattern.html');
            $body = str_replace('###USERNAME###', $user, $body);
            $body = str_replace('###SERVERNAME###', $this->config->config_entry('main|servername'), $body);
            $body = str_replace('###LINK###', $this->config->base_url, $body);
            $body = str_replace('###AMOUNT###', $amount, $body);
            $body = str_replace('###TYPE###', $type, $body);
            $body = str_replace('###BALANCE###', $balance["credits"], $body);
            $this->sendmail($email, 'Thank you for donation', $body);
            if($this->error == false){
                return true;
            } else{
                return false;
            }
        }

        public function sent_donate_email_admin($user, $server, $email, $amount, $type, $balance, $system)
        {
            $body = @file_get_contents(APP_PATH . DS . 'data' . DS . 'email_patterns' . DS . 'donate_email_admin_pattern.html');
            $body = str_replace('###USERNAME###', $user, $body);
            $body = str_replace('###SERVERNAME###', $this->config->config_entry('main|servername'), $body);
            $body = str_replace('###LINK###', $this->config->base_url, $body);
            $body = str_replace('###AMOUNT###', $amount, $body);
            $body = str_replace('###TYPE###', $type, $body);
            $body = str_replace('###BALANCE###', $balance["credits"], $body);
            $body = str_replace('###SYSTEM###', $system, $body);
            $this->sendmail($email, 'New ' . $system . ' donation received', $body);
            if($this->error == false){
                return true;
            } else{
                return false;
            }
        }

        public function sendmail($recipients, $subject, $message)
        {
            $this->vars['email_config'] = $this->config->values('email_config');
            if(!$this->vars['email_config'])
                throw new Exception('Email settings not configured.');
            if(!isset($this->vars['email_config']['server_email']) || $this->vars['email_config']['server_email'] == '')
                throw new Exception('Server email is not set.');
            switch($this->vars['email_config']['mail_mode']){
                case 0:
                    try{
                        if(!isset($this->vars['email_config']['smtp_server']) || $this->vars['email_config']['smtp_server'] == '')
                            throw new Exception('SMTP Server is not set.');
                        if(!isset($this->vars['email_config']['smtp_port']) || $this->vars['email_config']['smtp_port'] == '' || !is_numeric($this->vars['email_config']['smtp_port']))
                            throw new Exception('SMTP Port is not set.');
                        $transport = Swift_SmtpTransport::newInstance($this->vars['email_config']['smtp_server'], (int)$this->vars['email_config']['smtp_port']);
                        if($this->vars['email_config']['smtp_use_ssl'] == 1){
                            $transport->setEncryption('ssl');
                        }
                        if($this->vars['email_config']['smtp_use_ssl'] == 2){
                            $transport->setEncryption('tls');
                        }
                        if($this->vars['email_config']['smtp_username'] != ''){
                            $transport->setUsername($this->vars['email_config']['smtp_username']);
                        }
                        if($this->vars['email_config']['smtp_password'] != ''){
                            $transport->setPassword($this->vars['email_config']['smtp_password']);
                        }
                        $mailer = Swift_Mailer::newInstance($transport);
                        $message = Swift_Message::newInstance()->setSubject($subject)->setFrom([$this->vars['email_config']['server_email'] => $this->config->config_entry('main|servername')])->setTo([$recipients])->setBody($message)->setContentType('text/html');
                        if(!$mailer->send($message, $failures)){
                            $this->error = 'Failed sending email to ' . print_r($failures, 1);
                            return false;
                        }
                        return true;
                    } catch(Exception $e){
                        $this->error = $e->getMessage();
                    } catch(Swift_ConnectionException $e){
                        $this->error = 'There was a problem communicating with the SMTP-Server. Error-Text: ' . $e->getMessage();
                    } catch(Swift_Message_MimeException $e){
                        $this->error = 'There was an unexpected problem building the email. Error-Text: ' . $e->getMessage();
                    } catch(Swift_TransportException $e){
                        $this->error = $e->getMessage();
                    }
                    break;
                case 1:
                    try{
                        $transport = Swift_MailTransport::newInstance();
                        $mailer = Swift_Mailer::newInstance($transport);
                        $message = Swift_Message::newInstance()->setSubject($subject)->setFrom([$this->vars['email_config']['server_email'] => $this->config->config_entry('main|servername')])->setTo([$recipients])->setBody($message)->setContentType('text/html');
                        if(!$mailer->send($message, $failures)){
                            $this->error = 'Failed sending email to ' . print_r($failures, 1);
                            return false;
                        }
                        return true;
                    } catch(Swift_ConnectionException $e){
                        $this->error = 'There was a problem communicating with the SMTP-Server. Error-Text: ' . $e->getMessage();
                    } catch(Swift_Message_MimeException $e){
                        $this->error = 'There was an unexpected problem building the email. Error-Text: ' . $e->getMessage();
                    } catch(Swift_TransportException $e){
                        $this->error = $e->getMessage();
                    }
                    break;
                case 2:
                    try{
                        $transport = Swift_SendmailTransport::newInstance('/usr/sbin/sendmail -bs');
                        $mailer = Swift_Mailer::newInstance($transport);
                        $message = Swift_Message::newInstance()->setSubject($subject)->setFrom([$this->vars['email_config']['server_email'] => $this->config->config_entry('main|servername')])->setTo([$recipients])->setBody($message)->setContentType('text/html');
                        if(!$mailer->send($message, $failures)){
                            $this->error = 'Failed sending email to ' . print_r($failures, 1);
                            return false;
                        }
                        return true;
                    } catch(Swift_ConnectionException $e){
                        $this->error = 'There was a problem communicating with the SMTP-Server. Error-Text: ' . $e->getMessage();
                    } catch(Swift_Message_MimeException $e){
                        $this->error = 'There was an unexpected problem building the email. Error-Text: ' . $e->getMessage();
                    } catch(Swift_TransportException $e){
                        $this->error = $e->getMessage();
                    }
                    break;
                case 3:
                    try{
                        $transport = SwiftSparkPost\Transport::newInstance($this->vars['email_config']['smtp_password']);
                        $mailer = Swift_Mailer::newInstance($transport);
                        $message = Swift_Message::newInstance()->setSubject($subject)->setFrom([$this->vars['email_config']['server_email'] => $this->config->config_entry('main|servername')])->setTo([$recipients])->setBody($message)->setContentType('text/html');
                        if(!$mailer->send($message, $failures)){
                            $this->error = 'Failed sending email to ' . print_r($failures, 1);
                            return false;
                        }
                        return true;
                    } catch(Swift_ConnectionException $e){
                        $this->error = 'There was a problem communicating with the SMTP-Server. Error-Text: ' . $e->getMessage();
                    } catch(Swift_Message_MimeException $e){
                        $this->error = 'There was an unexpected problem building the email. Error-Text: ' . $e->getMessage();
                    } catch(Swift_TransportException $e){
                        $this->error = $e->getMessage();
                    }
                    break;
            }
        }
    }