<?php
    if(!function_exists('utf8_uri_encode')){
        function utf8_uri_encode($utf8_string, $length = 0)
        {
            $unicode = '';
            $values = [];
            $num_octets = 1;
            $unicode_length = 0;
            $string_length = strlen($utf8_string);
            for($i = 0; $i < $string_length; $i++){
                $value = ord($utf8_string[$i]);
                if($value < 128){
                    if($length && ($unicode_length >= $length))
                        break;
                    $unicode .= chr($value);
                    $unicode_length++;
                } else{
                    if(count($values) == 0)
                        $num_octets = ($value < 224) ? 2 : 3;
                    $values[] = $value;
                    if($length && ($unicode_length + ($num_octets * 3)) > $length)
                        break;
                    if(count($values) == $num_octets){
                        if($num_octets == 3){
                            $unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]) . '%' . dechex($values[2]);
                            $unicode_length += 9;
                        } else{
                            $unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]);
                            $unicode_length += 6;
                        }
                        $values = [];
                        $num_octets = 1;
                    }
                }
            }
            return $unicode;
        }
    }
    if(!function_exists('_')){
        function _($text)
        {
            return __($text);
        }
    }
    if(!function_exists('seems_utf8')){
        function seems_utf8($str)
        {
            $length = strlen($str);
            for($i = 0; $i < $length; $i++){
                $c = ord($str[$i]);
                if($c < 0x80)
                    $n = 0; else if(($c & 0xE0) == 0xC0)
                    $n = 1;
                else if(($c & 0xF0) == 0xE0)
                    $n = 2;
                else if(($c & 0xF8) == 0xF0)
                    $n = 3;
                else if(($c & 0xFC) == 0xF8)
                    $n = 4;
                else if(($c & 0xFE) == 0xFC)
                    $n = 5;
                else return false;
                for($j = 0; $j < $n; $j++){
                    if((++$i == $length) || ((ord($str[$i]) & 0xC0) != 0x80))
                        return false;
                }
            }
            return true;
        }
    }
    if(!function_exists('to_case')){
        function to_case($str)
        {
            return strtoupper($str);
        }
    }
    if(!function_exists('seo_string')){
        function seo_string($title)
        {
            $title = strip_tags($title);
            $title = preg_replace('|%([a-fA-F0-9][a-fA-F0-9])|', '---$1---', $title);
            $title = str_replace('%', '', $title);
            $title = preg_replace('|---([a-fA-F0-9][a-fA-F0-9])---|', '%$1', $title);
            if(seems_utf8($title)){
                if(function_exists('mb_strtolower')){
                    $title = mb_strtolower($title, 'UTF-8');
                }
                $title = utf8_uri_encode($title, 200);
            }
            $title = strtolower($title);
            $title = preg_replace('/&.+?;/', '', $title);
            $title = str_replace('.', '-', $title);
            $title = preg_replace('/[^%a-z0-9 _-]/', '', $title);
            $title = preg_replace('/\s+/', '-', $title);
            $title = preg_replace('|-+|', '-', $title);
            $title = trim($title, '-');
            return $title;
        }
    }
    if(!function_exists('is_ajax')){
        function is_ajax()
        {
            return isset($_POST['ajax']) || isset($_GET['ajax']);
        }
    }
    if(!function_exists('json')){
        function json($data = [])
        {
            header('Content-Type: application/json');
            die(json_encode($data));
        }
    }
    if(!function_exists('cms_version')){
        function cms_version($str)
        {
            return base64_decode($str);
        }
    }
    if(!function_exists('in_file')){
        function in_file()
        {
            if(defined('DMNCMS')){
                if(!DMNCMS)
                    die('Your not allowed to access this file!');
            } else{
                die('Your not allowed to access this file!');
            }
            return true;
        }
    }
    if (!function_exists('ip')) {
		function ip($int = false)
		{
			if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
				$ip = $_SERVER['HTTP_CLIENT_IP'];
			} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
				$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			} elseif (!empty($_SERVER['REMOTE_ADDR'])) {
				$ip = $_SERVER['REMOTE_ADDR'];
			} elseif (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
				$ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
			} else {
				$ip = '0.0.0.0';
			}

			if (strpos($ip, ',') !== false) {
				list($ip) = explode(',', $ip);
														   
		   
			}

			$test = str_replace(array('.', ',', ' '), '', $ip);
			if (!ctype_digit($test)) {
				$ip = $_SERVER['REMOTE_ADDR'];
			}

			$ip = ip2long($ip);
			if (!$int) {
				$ip = long2ip($ip);
			}
			return $ip;
		}
	}
    if(!function_exists('use_funcs')){
        function use_funcs($a, $b, $c)
        {
            return str_repeat($c, 2) . to_case($b) . cms_version('MTEwU3RhYmxl');
        }
    }
    if(!function_exists('check_ip_white_list')){
        function check_ip_white_list($ip_list = [])
        {
            if(!is_array($ip_list)){
                if(strstr($ip_list, ',') !== false){
                    $ip_list = explode(',', $ip_list);
                } else{
                    $ip_list = [$ip_list];
                }
            }
            if(!in_array(ip(), $ip_list)){
                header("HTTP/1.1 403 Forbidden");
                exit('Restricted Area');
            }
        }
    }
    if(!function_exists('pre')){
        function pre($val, $return = false, $color = '#fff')
        {
            echo '<pre style="color: ' . $color . ';">';
            print_r($val, $return);
            echo '</pre>';
        }
    }
    if(!function_exists('writelog')){
        function writelog($logentry, $lgname)
        {
            $log = '[' . ip() . '] ' . $logentry . '';
            $log_name = APP_PATH . DS . 'logs' . DS . $lgname . '_' . date("m-d-y") . '.txt';
            $logfile = @fopen($log_name, "a+");
            if($logfile){
                fwrite($logfile, "[" . date("h:iA") . "] $log\r\n");
                fclose($logfile);
            }
        }
    }
    if(!function_exists('server_list')){
        // @ioncube.dk use_funcs("DmN ","cms", "DmN") -> "DmNDmNCMS110Stable"
        function server_list($serv = '', $check_multi_acc = false)
        {
            $file = file_get_contents(APP_PATH . DS . 'data' . DS . 'serverlist.json');
            $servers = json_decode($file, true);
            if(is_array($servers)){
                if($check_multi_acc == true){
                    return $servers['USE_MULTI_ACCOUNT_DB'];
                } else{
                    unset($servers['USE_MULTI_ACCOUNT_DB']);
                    if($serv != ''){
                        if(array_key_exists($serv, $servers)){
                            return $servers[$serv];
                        } else{
                            return false;
                        }
                    }
                    return $servers;
                }
            } else{
                throw new Exception('Unable to load server list. Please check configuration file.');
            }
        }
    }
    if(!function_exists('get_country_code')){
        // @ioncube.dk use_funcs("DmN ","cms", "DmN") -> "DmNDmNCMS110Stable"
        function get_country_code($ip = '127.0.0.1')
        {
            if(filter_var($ip, FILTER_VALIDATE_IP) != false){
                if($ip != '127.0.0.1'){
                    return collect_country($ip);
                }
            }
            return 'us';
        }
    }
    if(!function_exists('collect_country')){
        function collect_country($ip = '')
        {
            $insert = true;
            $country_list = file_get_contents(APP_PATH . DS . 'data' . DS . 'country_list.txt');
            if(empty($country_list)){
                $country = find_country_code($ip);
                $ip_data = [$ip => $country];
            } else{
                $ip_data = unserialize($country_list);
                if(array_key_exists($ip, $ip_data)){
                    $country = $ip_data[$ip];
                    $insert = false;
                } else{
                    $country = find_country_code($ip);
                    $ip_data[$ip] = $country;
                }
            }
            if($insert){
                file_put_contents(APP_PATH . DS . 'data' . DS . 'country_list.txt', serialize($ip_data));
            }
            return $country;
        }
    }
    if(!function_exists('find_country_code')){
        function find_country_code($ip)
        {
            static $geoData = null;
            if($geoData == null)
                $geoData = geoip_open(APP_PATH . DS . 'data' . DS . 'GeoIP.dat', GEOIP_STANDARD);
			//if(filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)){
			//	return strtolower(geoip_country_code_by_addr_v6($geoData, $ip));
			//} 
			//else{
				return strtolower(geoip_country_code_by_addr($geoData, $ip));
			//}
        }
    }
    function g($v, $w)
    {
        $x = $v . ' yes';
        $x .= ' ' . str_repeat($w, 2);
        $x .= ' ' . substr($w, 0, -2);
        return $x;
    }

    if(!function_exists('findCountryCodeRemotely')){
        function findCountryCodeRemotely($ip)
        {
            $opts = ['http' => ['header' => "User-Agent:Mozilla/5.0 (Windows NT 6.2) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.75 Safari/537.1\r\n", 'timeout' => 10]];
            $context = stream_context_create($opts);
            if(($get_ip_info = file_get_contents('http://www.geoplugin.net/json.gp?ip=' . $ip, false, $context)) != false){
                $get_ip_info = json_decode($get_ip_info, true);
                return isset($get_ip_info['geoplugin_countryCode']) ? strtolower($get_ip_info['geoplugin_countryCode']) : 'us';
            }
            return 'us';
        }
    }
    if(!function_exists('arithmetic')){
        /*function arithmetic($string)
        {
            while($string != ($test = preg_replace_callback('/\(([^()]*)\)/', function ($matches) {
                    return arithmetic($matches[1]);
                }, $string))){
                $string = $test;
            }
            preg_match_all('![-+/*].*?[\d.]+!', "+$string", $matches);

            return array_reduce($matches[0], function ($number, $matches) {
                $operator = $matches[0];
                $matches[0] = ' ';

                return $operator == '+' ? $number + $matches : ($operator == '-' ? $number - $matches : ($operator == '*' ? $number * $matches : $number / $matches));
            });
        }*/
        function arithmetic($equation)
        {
            $result = 0;
            $equation = preg_replace("/[^a-z0-9+\-.*\/()%]/", "", $equation);
            $equation = preg_replace("/([a-z])+/i", "\$$0", $equation);
            $equation = preg_replace("/([+-])([0-9]{1})(%)/", "*(1\$1.0\$2)", $equation);
            $equation = preg_replace("/([+-])([0-9]+)(%)/", "*(1\$1.\$2)", $equation);
            $equation = preg_replace("/([0-9]{1})(%)/", ".0\$1", $equation);
            $equation = preg_replace("/([0-9]+)(%)/", ".\$1", $equation);
            if($equation != ""){
                $result = @eval("return " . $equation . ";");
            }
            if($result == null){
                return 0;
            }
            return $result;
        }
    }
    function getPHPExecutablePath()
    {
        if(strtolower(PHP_SHLIB_SUFFIX) === 'dll'){
            $paths = explode(PATH_SEPARATOR, getenv('PATH'));
            foreach($paths as $path){
                if(strstr($path, 'php.exe') && isset($_SERVER["WINDIR"]) && file_exists($path) && is_file($path)){
                    return $path;
                } else{
                    $php_executable = $path . DIRECTORY_SEPARATOR . "php" . (isset($_SERVER["WINDIR"]) ? ".exe" : "");
                    if(file_exists($php_executable) && is_file($php_executable)){
                        return $php_executable;
                    }
                }
            }
            return PHP_BINARY;
        } else{
            return PHP_BINDIR . DS . 'php';
        }
    }

    function isCommandLineInterface()
    {
        return (php_sapi_name() === 'cli');
    }

    if(!function_exists('load_class')){
        function load_class($class)
        {
            static $_classes = [];
            if(isset($_classes[$class])){
                return $_classes[$class];
            }
            $name = false;
            $file = SYSTEM_PATH . DS . $class . '.class.php';
            if(file_exists($file)){
                $name = $class;
                if(class_exists($name) === false){
                    require($file);
                }
            }
            if($name === false){
                exit('Unable to locate the specified class: ' . $class . '.php');
            }
            is_loaded($class);
            $_classes[$class] = new $name();
            return $_classes[$class];
        }
    }
    if(!function_exists('is_loaded')){
        function is_loaded($class = '')
        {
            static $_is_loaded = [];
            if($class != ''){
                $_is_loaded[strtolower($class)] = $class;
            }
            return $_is_loaded;
        }
    }
    if(!function_exists('array_save')){
        function array_save($array, $file)
        {
            file_put_contents($file, json_encode($array), LOCK_EX);
        }
    }
    if(!function_exists('array_load')){
        function array_load($file)
        {
            static $array_list = [];
            $filehash = crc32($file);
            if(!isset($array_list[$filehash])){
                $array_list[$filehash] = json_decode(file_get_contents($file), true);
                if(json_last_error() !== JSON_ERROR_NONE){
                    throw new Exception('Array cannot be decoded!');
                }
            }
            return $array_list[$filehash];
        }
    }

    function get_autoupdate_file($file)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, 'http://DmNUpdateService:a7145d355d740865df1d9db5e3d5ba30@dmncms.net/autoupdate/' . $file);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_USERAGENT, 'ApiQuery-Bot v1.0');
        $data = curl_exec($curl);
        $statuscode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        if($statuscode == 200){
            return $data;
        } else{
            return false;
        }
    }

    function log_post()
    {
        if(isset($_POST) && !empty($_POST)){
            $kv = [];
            foreach($_POST as $k => $v){
                if(is_array($v)):
                    $temp = [];
                    foreach($v as $v2){
                        $temp[] = $v2;
                    }
                    $kv[] = $k . ' = ' . join('|', $temp);
                else:
                    $kv[] = $k . ' = ' . $v;
                endif;
            }
            $post_vars = join('&', $kv);
            writelog($post_vars, '$_POST');
        }
    }

    function log_get()
    {
        if(isset($_GET) && !empty($_GET)){
            $kv = [];
            foreach($_GET as $k => $v){
                if(is_array($v)):
                    $temp = [];
                    foreach($v as $v2){
                        $temp[] = $v2;
                    }
                    $kv[] = $k . ' = ' . join('|', $temp);
                else:
                    $kv[] = $k . ' = ' . $v;
                endif;
            }
            $post_vars = join('&', $kv);
            writelog($post_vars, '$_GET');
        }
    }
	
	if(!function_exists('print_exception')){
        function print_exception($e)
        {
            ob_clean();
            $message = '<p>' . implode('</p><p>', (!is_array($e->getMessage())) ? [$e->getMessage()] : $e->getMessage()) . '</p>';
            $html = '<!DOCTYPE html>
				<html lang="en">
				<head>
				<title>Error</title>
				<style type="text/css">

				::selection{ background-color: #E13300; color: white; }
				::moz-selection{ background-color: #E13300; color: white; }
				::webkit-selection{ background-color: #E13300; color: white; }

				body {
					background-color: #fff;
					margin: 40px;
					font: 13px/20px normal Helvetica, Arial, sans-serif;
					color: #4F5155;
				}

				a {
					color: #003399;
					background-color: transparent;
					font-weight: normal;
				}

				h1 {
					color: #444;
					background-color: transparent;
					border-bottom: 1px solid #D0D0D0;
					font-size: 19px;
					font-weight: normal;
					margin: 0 0 14px 0;
					padding: 14px 15px 10px 15px;
				}

				code {
					font-family: Consolas, Monaco, Courier New, Courier, monospace;
					font-size: 12px;
					background-color: #f9f9f9;
					border: 1px solid #D0D0D0;
					color: #002166;
					display: block;
					margin: 14px 0 14px 0;
					padding: 12px 10px 12px 10px;
				}

				#container {
					margin: 10px;
					border: 1px solid #D0D0D0;
					-webkit-box-shadow: 0 0 8px #D0D0D0;
				}

				p {
					margin: 12px 15px 12px 15px;
				}
				</style>
				</head>
				<body>
					<div id="container">
						<h1>Error</h1>
						' . $message . '
					</div>
				</body>
				</html>';
            echo $html;
        }
    }